<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

$jenis = $_GET['jenis'] ?? '';

// query dasar
$sql = "SELECT s.*, a.nama 
        FROM simpanan s 
        JOIN anggota a ON s.anggota_id = a.id";

if ($jenis != '') {
    $sql .= " WHERE s.jenis = ?";
    $stmt = $db->prepare($sql);
    $stmt->bind_param("s", $jenis);
    $stmt->execute();
    $result = $stmt->get_result();
} else {
    $result = $db->query($sql);
}
?>

<h2>Laporan Simpanan</h2>

<form method="GET">
    <select name="jenis">
        <option value="">Semua Jenis</option>
        <option value="pokok">Pokok</option>
        <option value="wajib">Wajib</option>
        <option value="sukarela">Sukarela</option>
    </select>
    <button type="submit" class="btn btn-primary">Filter</button>
</form>

<table class="table">
    <thead>
        <tr>
            <th>No</th>
            <th>Anggota</th>
            <th>Jenis</th>
            <th>Jumlah</th>
            <th>Tanggal</th>
        </tr>
    </thead>
    <tbody>
        <?php 
        $no = 1; 
        $total = 0;
        while ($row = $result->fetch_assoc()):
            $total += $row['jumlah'];
        ?>
        <tr>
            <td><?= $no++; ?></td>
            <td><?= $row['nama']; ?></td>
            <td><?= ucfirst($row['jenis']); ?></td>
            <td>Rp <?= number_format($row['jumlah'], 0, ',', '.'); ?></td>
            <td><?= date('d-m-Y', strtotime($row['tanggal'])); ?></td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<h3>Total: Rp <?= number_format($total, 0, ',', '.'); ?></h3>

<?php require_once '../../templates/footer.php'; ?>
